<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TipoLiquidacion extends Model 
{

    protected $table = 'tipo_liquidaciones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');
    protected $visible = array('name');

    public function liquidaciones()
    {
        return $this->hasMany('Liquidacion', 'liquidacion_id');
    }

}